﻿$(document).ready(function () {
    bindChartControls();

    $(".v-survey-status a").on("click", function () {
        a4.showBusyBox();
    });
});

function bindChartControls() {
    $(document).on("change", ".h-chartTypeSelector", function (e) {
        var $c = $(this);
        var type = $c.val()

        var variable = $(this).closest(".variableDetails.v-variableDetails");
       
        if (variable.length > 0)
        {
           // var surveyId = $("#survey-block").attr("data-surveyid");            
            var varId = $(variable).attr("data-variable-id");

            if (varId != undefined & varId > 0)
                a4.callServerMethod(a4.getSurveyAction("UpdateVariableChartType", "Analyze"), {variableId: varId, chartType:type  });
        }

        // highcharts cannot directly switch between bars and columns
        if (type == "bar" || type == "column") {
            $(".v-hcChart", $c.parents(".v-chartControl")).highcharts().destroy();
           
            displayHighGraph($(".v-hcChart", $c.parents(".v-chartControl")), $c.val(), false);
        } else {
            var series = $(".v-hcChart", $c.parents(".v-chartControl")).highcharts().series;
            $.each(series, function () {
                this.update({ type: $c.val() });
            });
        }
         
    });
}

function displayHighGraph(graph, type, animation) {
    var $container = $(graph);
    var url = $container.data("src");
    var $chartControl = $container.closest(".v-chartControl");

    if (!url) return;

    if (typeof type != 'undefined' && null !== type) {
        chartType = type;
    } else {
        var chartType = 'pie';
        if (typeof options != 'undefined' && null !== options) {
            chartType = options.ChartType;
        }
    }

    if (chartType != 0) {

        $chartControl.addClass("visible");

        a4.callServerMethod(url, { chartType: chartType },
           function (chartData) {

               if (typeof animation != 'undefined' && null !== animation) {
                   chartData.animation = animation;
               }

               a4.initChart($container, chartData);

               $container.removeClass("no-print");
               $container.closest(".v-chartControl").removeClass("no-print");
           }
        );
    } else {
        $chartControl.removeClass("visible");
    }
}

function DisableEnter(e) {
    return (e.keyCode != 13);
}